<?php
session_start();
include "../../app/db.php";

if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'admin') {
    header("Location: ../login.php");
    exit();
}

include "header.php";
$recharges = mysqli_query($conn, "SELECT recharges.*, users.name FROM recharges 
                                  JOIN users ON users.id = recharges.user_id
                                  ORDER BY recharges.id DESC");
?>

<h2 class="text-2xl font-bold mb-6">Fastag Recharges</h2>

<table class="w-full bg-white shadow rounded-xl overflow-hidden">
<tr class="bg-gray-200">
   <th class="p-3">User</th>
   <th class="p-3">Vehicle</th>
   <th class="p-3">Provider</th>
   <th class="p-3">Amount</th>
   <th class="p-3">Status</th>
   <th class="p-3">Date</th>
</tr>

<?php while($r = mysqli_fetch_assoc($recharges)): ?>
<tr class="border-b hover:bg-gray-50">
   <td class="p-3"><?= $r['name'] ?></td>
   <td class="p-3"><?= $r['vehicle_number'] ?></td>
   <td class="p-3"><?= $r['provider'] ?></td>
   <td class="p-3 font-bold">₹ <?= $r['amount'] ?></td>
   <td class="p-3 text-green-600"><?= $r['status'] ?></td>
   <td class="p-3"><?= $r['created_at'] ?></td>
</tr>
<?php endwhile; ?>
</table>

<?php include "../footer.php"; ?>
