<?php
session_start();
include "../../app/db.php";

// admin check
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'admin') {
    header("Location: ../login.php");
    exit();
}

include "header.php";

// Fetch existing commission settings
$cm = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM commission LIMIT 1"));

$message = null;

// Update commission on submit
if ($_SERVER["REQUEST_METHOD"] == "POST") {

    $type = $_POST['type'];
    $value = floatval($_POST['value']);

    if ($cm) {
        mysqli_query($conn, "UPDATE commission SET type='$type', value='$value' WHERE id=".$cm['id']);
    } else {
        mysqli_query($conn, "INSERT INTO commission(type, value) VALUES('$type', '$value')");
    }

    $message = "Commission Settings Updated Successfully!";
    // Refresh data
    $cm = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM commission LIMIT 1"));
}
?>

<h2 class="text-2xl font-bold mb-6">Commission Settings</h2>

<div class="bg-white p-6 rounded-xl shadow max-w-lg mx-auto">

<?php if(!empty($message)): ?>
<p class="text-green-600 font-semibold mb-4"><?= $message ?></p>
<?php endif; ?>

<form method="POST">

    <label class="font-semibold">Commission Type</label>
    <select name="type" required class="w-full p-3 border rounded mb-4">
        <option value="fixed" <?= ($cm['type']=="fixed"?"selected":"") ?>>Fixed Amount</option>
        <option value="percentage" <?= ($cm['type']=="percentage"?"selected":"") ?>>Percentage (%)</option>
    </select>

    <label class="font-semibold">Commission Value</label>
    <input type="number" step="0.01" name="value" required 
           value="<?= $cm['value'] ?>" 
           class="w-full p-3 border rounded mb-4" />

    <button class="w-full bg-blue-600 text-white py-3 rounded hover:bg-blue-700 transition">
        Save Commission
    </button>

</form>
</div>

<?php include "footer.php"; ?>
