<?php 
session_start();
include "../app/db.php";

$error = null; // default

if ($_SERVER["REQUEST_METHOD"] == "POST") {
   $email = trim($_POST['email']);
   $password = $_POST['password'];

   // basic protection
   $email = mysqli_real_escape_string($conn, $email);

   $query = mysqli_query($conn, "SELECT * FROM users WHERE email='$email' LIMIT 1");
   $user = mysqli_fetch_assoc($query);

   if ($user && password_verify($password, $user['password'])) {

      $_SESSION['user_id'] = $user['id'];
      $_SESSION['name']    = $user['name'];
      $_SESSION['role']    = $user['role'];

      // IMPORTANT: use relative path so that subfolder me bhi chale
      if ($user['role'] == 'admin') {
         header("Location: admin/index.php");
      } else {
         header("Location: dashboard.php");
      }
      exit();

   } else {
      $error = "Invalid Email or Password!";
   }
}

// ABHI TAK KOI HTML OUTPUT NAHI GAYA
include "header.php";
?>

<div class="max-w-lg mx-auto bg-white shadow p-6 rounded-xl">
   <h2 class="text-2xl font-bold mb-4 text-center">Login</h2>
   <?php if(!empty($error)): ?>
      <p class="text-red-500 mb-3"><?= $error ?></p>
   <?php endif; ?>

   <form method="POST">
      <input type="email" name="email" placeholder="Email" required class="w-full mb-3 p-3 border rounded" />
      <input type="password" name="password" placeholder="Password" required class="w-full mb-4 p-3 border rounded" />
      <button class="w-full bg-blue-600 text-white py-3 rounded hover:bg-blue-700 transition">Login</button>
   </form>

   <p class="text-center mt-4">Don't have an account? 
     <a href="register.php" class="text-blue-600">Register</a>
   </p>
</div>

<?php include "footer.php"; ?>
