<?php 
include "../app/auth.php";
include "../app/db.php";

$user_id = $_SESSION['user_id'];
$message = null;

// user balance fetch
$userdata = mysqli_fetch_assoc(mysqli_query($conn, "SELECT balance FROM users WHERE id='$user_id'"));

// fetch commission settings
$cm = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM commission LIMIT 1"));

if ($_SERVER["REQUEST_METHOD"] == "POST") {

    $vehicle = mysqli_real_escape_string($conn, $_POST['vehicle']);
    $provider = mysqli_real_escape_string($conn, $_POST['provider']);
    $amount = floatval($_POST['amount']);

    // calculate commission
    if ($cm['type'] == "fixed") {
        $commission = $cm['value'];
    } else {
        $commission = ($amount * $cm['value']) / 100;
    }

    $totalDebit = $amount + $commission;

    if ($amount >= 50) {

        // check balance
        if ($userdata['balance'] >= $totalDebit) {

            // deduct wallet balance
            $newBalance = $userdata['balance'] - $totalDebit;
            mysqli_query($conn, "UPDATE users SET balance='$newBalance' WHERE id='$user_id'");
            $userdata['balance'] = $newBalance;

            // recharge entry insert
            mysqli_query($conn, "INSERT INTO recharges(user_id, vehicle_number, provider, amount, status, api_response)
                                 VALUES('$user_id', '$vehicle', '$provider', '$amount', 'success', 'Manual Recharge Complete')");

            // add wallet transaction log
            mysqli_query($conn, "INSERT INTO wallet_transactions(user_id, amount, type, description)
                                 VALUES('$user_id', '$totalDebit', 'deduct', 'Fastag Recharge + Commission')");

            $message = "Recharge Successful for $vehicle<br>
                        Recharge Amount: ₹$amount<br>
                        Commission: ₹$commission<br>
                        Total Debited: ₹$totalDebit";

        } else {
            $message = "Insufficient Wallet Balance! Required ₹$totalDebit";
        }

    } else {
        $message = "Minimum Recharge is ₹50";
    }
}

include "header.php";
?>

<h2 class="text-2xl font-bold mb-4">FASTag Recharge</h2>

<div class="bg-white p-6 rounded-xl shadow max-w-lg mx-auto">
    <?php if(!empty($message)): ?>
        <p class="text-blue-600 font-semibold mb-3"><?= $message ?></p>
    <?php endif; ?>

    <p class="mb-3 text-lg font-semibold">
        Current Balance: <span class="text-green-600 font-bold">₹ <?= $userdata['balance'] ?></span>
    </p>

    <form method="POST">
        <input type="text" name="vehicle" placeholder="Vehicle Number (e.g. RJ14XX1234)" required class="w-full p-3 border rounded mb-4" />

        <select name="provider" required class="w-full p-3 border rounded mb-4">
            <option value="">Select FASTag Provider</option>
            <option>HDFC Fastag</option>
            <option>ICICI Fastag</option>
            <option>SBI Fastag</option>
            <option>Paytm Fastag</option>
            <option>Axis Bank Fastag</option>
        </select>

        <input type="number" name="amount" placeholder="Recharge Amount" required min="50" class="w-full p-3 border rounded mb-4" />

        <button class="w-full bg-green-600 text-white py-3 rounded hover:bg-green-700 transition">
            Recharge Now
        </button>
    </form>
</div>

<?php include "footer.php"; ?>
