/*
 * Decompiled with CFR 0.152.
 */
package com.securepay.nb.controller;

import com.securepay.nb.nbcommons.beans.IJWTInfo;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.stereotype.Service;

@Service
public class JWTAuthService {
    private static String secretKey;

    @Value(value="${jwt.secretKey}")
    public void setsecretKey(String secretKey) {
        JWTAuthService.secretKey = secretKey;
    }

    public static String generateJWSToken(IJWTInfo jwtInfo) {
        Date exp = Date.from(ZonedDateTime.now().plusDays(1L).toInstant());
        SecretKey key = Keys.hmacShaKeyFor((byte[])secretKey.getBytes());
        Claims claims = Jwts.claims().setSubject(jwtInfo.getUser_id());
        String token = Jwts.builder().setClaims(claims).signWith((Key)key, SignatureAlgorithm.HS512).setExpiration(exp).compact();
        return token;
    }

    public static UsernamePasswordAuthenticationToken validateToken(String token) {
        if (token != null) {
            try {
                Claims user = (Claims)Jwts.parser().setSigningKey((Key)Keys.hmacShaKeyFor((byte[])secretKey.getBytes())).parseClaimsJws(token).getBody();
                if (user != null) {
                    return new UsernamePasswordAuthenticationToken((Object)user, null, new ArrayList());
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

